####Würfeln der Bedingung####
bed <- sample(1:3, 1)

#Ausgabe der Bedingung
if (bed %% 3 == 0){
  print("Bedingung 1")
}else if (bed %% 3 == 1){
  print("Bedingung 2")
}else {
  print ("Bedingung 3")}


####Welche Noten würfeln wir uns heute?####

#Datensatz erstellen und Punktzahl würfeln
noten <- data.frame(
  Name = c("Pauline", "Mathilde", "Maddie", "Nina"),
  Punkte = sample(1:100, 4))

#Leere Notenvariable erstellen
noten$note <- 4*NA
noten


#Liste durchgehen und Noten eintragen 
for (i in 1:nrow(noten)){
  if (noten$Punkte[i] >= 80){
    noten$note[i] <- "sehr gut"
    }else if (noten$Punkte[i] >= 60){
      noten$note[i] <- "gut"
    }else if (noten$Punkte[i] >= 40){
        noten$note[i] <- "okay"
    }else {
      noten$note[i] <- "anwesend"}
  }

sample(noten, 1)#Wir sehen: Es werden leider Spalten gezogen, s. Umstruktuieren letzte Sitzung
noten[sample(1:4, 1),]

####Wer braucht eine Intervention?####
BDI_daten <- data.frame(Name = c("Anna", "Ben", "Clara", "David", "Emma", "Felix", "Greta", "Hans", "Isabel", "Jonas",
               "Klara", "Lukas", "Mia", "Noah", "Olivia", "Paul", "Quentin", "Rosa", "Sophie", "Tim"))

BDI_daten$Score <- sample(0:63, 20, replace =TRUE)

BDI_daten$Intervention <- c(20*NA)

for (t in 1:length(BDI_daten$Score)){
  if (BDI_daten$Score[t] > 19){ #da ab 20 mittelgradige Depr.
    BDI_daten$Intervention[t] <- 1}
}

BDI_daten$Intervention_kurz <- ifelse(BDI_daten$Score > 19, "Intervention",
                                  ifelse (BDI_daten$Score > 9, "Graubereich",
                                              "Alles gut"))


#Kürzere Schreibweise -> Man sieht: Viele Wege führen nach Rom
#Man sieht ausserdem: R ist nicht so streng mit einrücken 





####Hausaufgaben####

set.seed(1)

BDI_daten$Item4 <- sample (1:4, 20, replace = TRUE)

#1. Das Item muss rekodiert werden, benutze "if" Abfragen um es umzupolen (1 = 4, 2 = 3 etc.)

for (i in 1:20){
  if (BDI_daten$Item4[i] == 1){
    BDI_daten$Item4_r[i] <- 4
  }
  else if (BDI_daten$Item4[i] == 3){
    BDI_daten$Item4_r[i] <- 2
  }
  else if (BDI_daten$Item4[i] == 2){
    BDI_daten$Item4_r[i] <- 3
  }
  else if (BDI_daten$Item4[i] == 4){
    BDI_daten$Item4_r[i] <- 1
  }
}

#2. Unsere Intervention zeigt sich als kaum wirksam, vielleicht weil gesunde Probanden dabei sind? Schmeiß alle
#Personen mit einem Score von unter 20 raus

for (i in 20:1){
  if (BDI_daten$Score[i] < 20){
    BDI_daten[i,] <- NULL
  }
}




